<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App;
use DateTime;
use PDF;



// namespace App\Exceptions;

use Exception;

class dashboardController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request){

    	$page = $request->input('page');
    	$searchtype = $request->input('searchtype');
    	$search = $request->input('search');
    	$tahun = $request->input('tahun');


    	$customers_count = DB::table('customers')
    	->where('nama','like','%'.$search.'%')
    	->orWhere('alamat','like','%'.$search.'%')
    	->count();

    	$pageCount = floor($customers_count/5);
    	
    	$getCustomer = json_decode($this->getCustomer($tahun,$page,$searchtype,$search),true);
    	return view('dashboard', ['customers' => $getCustomer, 'pagecount' => $pageCount]);

    }

    public function registerbro(){
    	return view('auth.register');
    }

    public function open_tambah_pelanggan(){

    	return view('openTambahPelanggan');

    }



    public function pengisi_pelanggan(){
    	echo 'isi pelanggan';

    	for ($i=0; $i < 250; $i++) { 
    		
    		$query = DB::table('customers')->insert(
		    	['nama' => 'nama'.$i, 'telepon' => $i]
			);

    	}
    }

    public function func_tambah_pelanggan(Request $request){
    	$nama = $request->input('nama');
    	$telepon = $request->input('telepon');
    	$alamat = $request->input('alamat');
    	$tgl_pasang = $request->input('tgl_pasang');
    	$speed = $request->input('speed');
    	$nominal_tagihan = $request->input('nominal_tagihan');

    	$query = DB::table('customers')->insert(
		    ['nama' => $nama, 'telepon' => $telepon, 'alamat' => $alamat, 'tgl_pasang' => $tgl_pasang, 'speed' => $speed, 'nominal_tagihan' => $nominal_tagihan]
		);

		if ($query) {
		     return redirect('dashboard?page=0&search=');
		}
    }

    public function func_edit_pelanggan(Request $request){

    	$customer_id = $request->input('customerid_edit');
    	$nama = $request->input('editnama');
    	$speed = $request->input('editspeed');
    	$nominal_tagihan = $request->input('editnominaltagihan');
    	$nomor_telepon = $request->input('edittelepon');
    	$tgl_pasang = $request->input('edittglpasang');
    	$alamat = $request->input('editalamat');
    	$url = $request->input("editurl");

    	echo $customer_id;
    	echo $nama;
    	echo $speed;
    	echo $url;

    	$query = DB::table('customers')
              ->where('customer_id', $customer_id)
              ->update(
              	['nama' => $nama, 'speed' => $speed, 'nominal_tagihan' => $nominal_tagihan, 'telepon' => $nomor_telepon, 'tgl_pasang' => $tgl_pasang,'alamat' => $alamat]
          );

            if ($query) {
            	
            	return redirect($url);
            	
            }else{
            	return $query;
            }


    }


    public function func_hapus_pelanggan(Request $request){

    	$customer_id = $request->input('customerid_hapus');
    	$nama = $request->input('hapusnama');
    	$url = $request->input("hapusurl");

    	
    	echo $url;

    	$query = DB::table('customers')
              ->where('customer_id', $customer_id)
              ->update(
              	['nama' => $nama , 'deleted' => "1"]
          );

            if ($query) {
            	
            	return redirect($url);
            	
            }else{
            	return $query;
            }


    }

    public function postBayar(Request $request){
    	$customer_id = $request->input('customer_id');
    	$bulan = $request->input('bulan');
    	$tahun = $request->input('tahun');
    	$nominal = $request->input('nominal');

    	$query = DB::table('pembayarans')->insert(
		    [
		    	'customer_id' => $customer_id,
		    	'bulan' => $bulan,
		    	'tahun' => $tahun,
		    	'nominal' => $nominal
		    ]
		);

		if ($query) {
		     return "good";
		}else{
			return "fail";
		}
    }

    public function postTidakBayar(Request $request){
    	$customer_id = $request->input('customer_id');
    	$bulan = $request->input('bulan');
    	$tahun = $request->input('tahun');

    	$query = DB::table('pembayarans')
    	->where('customer_id', '=', $customer_id)
    	->where('bulan', '=', $bulan)
    	->where('tahun', '=', $tahun)
    	->delete();

		if ($query) {
		     return "good";
		}else{
			return "fail";
		}
    }

    public function getCustomer($tahun,$page,$searchtype,$search){
    	$stringResult = "";

    	
    	$stringResult.= "[";

    	if ($search != "alldata") {

    		if ($searchtype == "alamat") {
    			$customers = DB::table('customers')
    				->where('alamat','like','%'.$search.'%')
    				->where('deleted',null)
			    	->offset(5*$page)
                	->limit(5)
                	->get();
    		}else{
    			$customers = DB::table('customers')
    				->where('nama','like','%'.$search.'%')
    				->where('deleted',null)
			    	->offset(5*$page)
                	->limit(5)
                	->get();
    		}
             


    	}else{

    		$customers = DB::table('customers')
    				->where('deleted',null)
			    	->offset(5*$page)
                	->limit(5)
                	->get();
    		
    	}
    	
    	if (count($customers) != 0) {
    		for ($i=0; $i < count($customers)-1; $i++) { 
			//inner index
			$stringResult.= "{";
			$stringResult.= "\"customer_id\":\"".$customers[$i]->customer_id."\",";
			$stringResult.= "\"nama\":\"".$customers[$i]->nama."\",";
			$stringResult.= "\"tahun\":\"".$tahun."\",";
			$stringResult.= "\"telepon\":\"".$customers[$i]->telepon."\",";
			$stringResult.= "\"alamat\":\"".$customers[$i]->alamat."\",";
			$stringResult.= "\"tgl_pasang\":\"".$customers[$i]->tgl_pasang."\",";
			$stringResult.= "\"speed\":\"".$customers[$i]->speed."\",";
			$stringResult.= "\"nominal_tagihan\":\"".$customers[$i]->nominal_tagihan."\",";

			for ($x=1; $x <= 12-1; $x++) { 
				$pembayaran = DB::table('pembayarans')
						->where('customer_id','=',$customers[$i]->customer_id)
						->where('bulan','=', $x)
						->where('tahun','=',$tahun)
						->get();	

						if ($pembayaran == "[]") {
							// $stringResult.= "bulan".$x."";
							$stringResult.= "\"bulan".$x."\":\"Belum Bayar\",";
						}else{
							$stringResult.= "\"bulan".$x."\":\"".$pembayaran[0]->id_bayar."\",";
							// $stringResult.= "[".$pembayaran[0]->id_bayar."]";
						}	
			}
			//outer index
				$pembayaran = DB::table('pembayarans')
						->where('customer_id','=',$customers[$i]->customer_id)
						->where('bulan','=', 12)
						->where('tahun','=',$tahun)
						->get();	

						if ($pembayaran == "[]") {
							// $stringResult.= "bulan".$x."";
							$stringResult.= "\"bulan12"."\":\"Belum Bayar\"";
						}else{
							$stringResult.= "\"bulan12"."\":\"".$pembayaran[0]->id_bayar."\"";
							// $stringResult.= "[".$pembayaran[0]->id_bayar."]";
						}
			//outer index

			$stringResult.= "},";
			//inner index
			}
				//last index
			$stringResult.= "{";
			$stringResult.= "\"customer_id\":\"".$customers[$i]->customer_id."\",";
			$stringResult.= "\"nama\":\"".$customers[$i]->nama."\",";
			$stringResult.= "\"tahun\":\"".$tahun."\",";
			$stringResult.= "\"telepon\":\"".$customers[$i]->telepon."\",";
			$stringResult.= "\"alamat\":\"".$customers[$i]->alamat."\",";
			$stringResult.= "\"tgl_pasang\":\"".$customers[$i]->tgl_pasang."\",";
			$stringResult.= "\"speed\":\"".$customers[$i]->speed."\",";
			$stringResult.= "\"nominal_tagihan\":\"".$customers[$i]->nominal_tagihan."\",";
			for ($x=1; $x <= 12-1; $x++) { 
				$pembayaran = DB::table('pembayarans')
						->where('customer_id','=',$customers[$i]->customer_id)
						->where('bulan','=', $x)
						->where('tahun','=',$tahun)
						->get();	

						if ($pembayaran == "[]") {
							// $stringResult.= "bulan".$x."";
							$stringResult.= "\"bulan".$x."\":\"Belum Bayar\",";
						}else{
							$stringResult.= "\"bulan".$x."\":\"".$pembayaran[0]->id_bayar."\",";
							// $stringResult.= "[".$pembayaran[0]->id_bayar."]";
						}
				
			}
			//outer index
				$pembayaran = DB::table('pembayarans')
						->where('customer_id','=',$customers[$i]->customer_id)
						->where('bulan','=', 12)
						->where('tahun','=',$tahun)
						->get();	

						if ($pembayaran == "[]") {
							// $stringResult.= "bulan".$x."";
							$stringResult.= "\"bulan12"."\":\"Belum Bayar\"";
						}else{
							$stringResult.= "\"bulan12"."\":\"".$pembayaran[0]->id_bayar."\"";
							// $stringResult.= "[".$pembayaran[0]->id_bayar."]";
						}
			//outer index

			$stringResult.= "}";
				//last index
		$stringResult.= "]";
		// $stringResult.= "'";
    	}else{
    		$stringResult = "[]";
    	}

		return $stringResult;
    
    }



     public function print_invoice(){
		date_default_timezone_set("Asia/Bangkok");

     	// $id_bayar = $_GET['bayar'];
     	$nama_pelangggan = $_GET['nama'];
     	$nomor_pelanggan = $_GET['nomor'];
     	$id_pelanggan = $_GET['id'];
     	$bulan = $_GET['bulan'];
     	$tahun = $_GET['tahun'];

     	$bulanTerakhir = $bulan;
     	$tahunTerakhir = $tahun;
     	$tgl_pasang = "";

     	$user = DB::table('customers')
     	->select('nama', 'telepon', 'alamat','tgl_pasang','speed', 'nominal_tagihan')
     	->where('customer_id','=',$id_pelanggan)
     	->get();

     	if ($bulan == 1) {
     		$tahunTerakhir = $tahun-1;
     		$bulanTerakhir = 13;
     	}

     	$pembayaran_terakhir = DB::table('pembayarans')
     	->select('id_bayar','bulan','tahun','nominal','customer_id','tgl_bayar')
     	->where('customer_id','=', $id_pelanggan)
     	->where('bulan','<',$bulanTerakhir)
     	->where('tahun','=',$tahunTerakhir)
     	->orderBy('tgl_bayar','desc')
     	->limit(1)
     	->get();

     	$tanggal_bayar = DB::table('pembayarans')
     	->select('tgl_bayar')
     	->where('customer_id','=', $id_pelanggan)
     	->where('bulan','=',$bulan)
     	->where('tahun','=',$tahun)
     	->get();

     	try{
     		$tgl_bayar_terakhir = $pembayaran_terakhir[0]->tgl_bayar;
     		$nominal_terakhir = $pembayaran_terakhir[0]->nominal;
     		$bulanTerakhir = $pembayaran_terakhir[0]->bulan;
     		$tahunTerakhir = $pembayaran_terakhir[0]->tahun;

     	}
     	catch(Exception $e){
     		$bulanTerakhir = "-";
     		$tahunTerakhir = "";
     		$tgl_bayar_terakhir = "-";
     		$nominal_terakhir = "-";

     	}

     	$alamat = $user[0]->alamat;

     	$dateObj   = DateTime::createFromFormat('!m', $bulan);
		$monthName = $dateObj->format('F'); // March

     	$timestamp = date("d/M/Y");

    	$pdf = App::make('dompdf.wrapper');


				$pdf->loadHTML('

			<!doctype html>
			<html margin:0px; padding:0px>
			
			<style>
				html{
				    margin-top:50px;
				    padding-top:20px;
				}
				body{
				    margin:0px;
				    padding:0px;
				}
			</style>
			<body>
			    
				
				<img id="logo" src="./image/logoinvoice.png" height="25%" alt="Logo" style="padding:0px; margin:0px">

				<hr style="height: 1px; background-color: black; padding:0px; margin:0px">

				<table style="width: 100%; margin-top:0px; margin-bottom:0px; padding-top:0px">
				
				  <tr style="border: 0px">
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">ID Pelanggan</td>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px"> : '.$id_pelanggan.'</td>

				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">Alamat</td>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">: '.$alamat.'</td>

					<td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">Speed</td>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">: '.$user[0]->speed.' Mb</td>

				    
				   </tr>
				  
				  <tr>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">Nama Pelanggan</td>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px"> : '.$nama_pelangggan.'</td>

				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">Tanggal Pemasangan</td>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">: '.$user[0]->tgl_pasang.'</td>

				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">Jatuh Tempo</td>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">: 20 '.$monthName.'</td>

				  </tr>
				  <tr>
				 	
				 	  <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">Abonemen </td>
				    <td style="border: 0px; padding-bottom:0px; padding-top:0px; font-size:12px">: Rp.'.number_format($user[0]->nominal_tagihan).',-</td>

				  </tr>
				 
				  
				</table>
		

				<style type="text/css">
					td, th {
						  border: 0.5px solid black;
						  text-align: left;
						  padding: 0px;
						  padding-left:8px;
						}

				</style>

				<h4 style="text-align: center; margin-top:0px; margin-bottom:5px">Pembayaran Terakhir	</h4>
			
				<table style="width: 100%;">
					<tr>
						<td style=" font-size:12px">Pembayaran Terakhir</td>
						<td style=" font-size:12px">Bulan</td>
						<td style=" font-size:12px">Nominal</td>
					</tr>
					<tr>
						<td style="font-size:12px">'.$tgl_bayar_terakhir.'</td>
						<td style="font-size:12px">'.$bulanTerakhir.' '.$tahunTerakhir.'</td>
						<td style="font-size:12px">'.$nominal_terakhir.'</td>
					</tr>
				</table>
				
				<h4 style="text-align: center; margin-bottom:0px; margin-top:10px">Tagihan Bulan Ini </h4>
				
				<table style="width: 100%; margin-top:0px; padding-top:0px">
					<tr>
						<td style=" font-size:12px" colspan="3">Tagihan Bulan Ini</td>
						
					</tr>
					<tr>
						
						<td colspan="2" style="font-size:12px">'.date('F', mktime(0, 0, 0, $bulan, 10)).' '.$tahun.'</td>
						<td style="width:35%; font-size:12px"> Rp.'.number_format($user[0]->nominal_tagihan).',-</td>
					</tr>
					<tr>
						
						<td colspan="2" style="font-size:12px">Total</td>
						<td style="font-size:12px">Rp.'.number_format($user[0]->nominal_tagihan).',-</td>
					</tr>
					<tr>
				
						<td colspan="2" style="font-size:12px">Terbilang</td>
						<td style="font-size:12px">'.$this->terbilang($user[0]->nominal_tagihan).' Rupiah </td>
					</tr>
				</table>
				
				<br>
				
				<table style="width: 100%; margin:0px; padding:0px">
					<tr>
						<td style="border: 0px"></td>
						<td style="border: 0px"></td>
						
						<td style="width: 30%; border: 0px; font-size:12px">
						Grenden, '. date_format(date_create($tanggal_bayar[0]->tgl_bayar),"d-M-Y").'<br>
						Admin
						</td>
					</tr>
				
					<tr>
						<td style="border: 0px"></td>
					</tr>
					<tr>
						<td style="border: 0px"></td>
					</tr>
					<tr style="margin:0px; padding:0px">
						<td style="border: 0px"></td>
						<td style="border: 0px; padding-bottom:50px"></td>
						<td style="width: 30%; border: 0px; vertical-align: bottom; margin:0px; padding:0px;">..................................</td>
					</tr>
				</table>


			</body>
			</html>


			')
			->setPaper( array(0,0,595,420))
				;
        //->setPaper( 'a5','landscape')
		// return $pdf->stream();
		// $pdf->loadView('dashboard');
		return $pdf->stream();


    }

    public function penyebut($nilai) {
		$nilai = abs($nilai);
		$huruf = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
		$temp = "";
		if ($nilai < 12) {
			$temp = " ". $huruf[$nilai];
		} else if ($nilai <20) {
			$temp = $this->penyebut($nilai - 10). " belas";
		} else if ($nilai < 100) {
			$temp = $this->penyebut($nilai/10)." puluh". $this->penyebut($nilai % 10);
		} else if ($nilai < 200) {
			$temp = " seratus" . $this->penyebut($nilai - 100);
		} else if ($nilai < 1000) {
			$temp = $this->penyebut($nilai/100) . " ratus" . $this->penyebut($nilai % 100);
		} else if ($nilai < 2000) {
			$temp = " seribu" . $this->penyebut($nilai - 1000);
		} else if ($nilai < 1000000) {
			$temp = $this->penyebut($nilai/1000) . " ribu" . $this->penyebut($nilai % 1000);
		} else if ($nilai < 1000000000) {
			$temp = $this->penyebut($nilai/1000000) . " juta" . $this->penyebut($nilai % 1000000);
		} else if ($nilai < 1000000000000) {
			$temp = $this->penyebut($nilai/1000000000) . " milyar" . $this->penyebut(fmod($nilai,1000000000));
		} else if ($nilai < 1000000000000000) {
			$temp = $this->penyebut($nilai/1000000000000) . " trilyun" . $this->penyebut(fmod($nilai,1000000000000));
		}     
		return $temp;
	}


	public function terbilang($nilai) {
		if($nilai<0) {
			$hasil = "minus ". trim($this->penyebut($nilai));
		} else {
			$hasil = trim($this->penyebut($nilai));
		}     		
		return $hasil;
	}




}
